Imports System.Data
Imports System.IO
Imports System.Runtime.Serialization.Formatters.Binary

Public Class Form1
    Inherits System.Windows.Forms.Form

    Private WithEvents menuItemClear As System.Windows.Forms.MenuItem
    Private WithEvents menuItemOpen As System.Windows.Forms.MenuItem
    Private WithEvents menuItemSave As System.Windows.Forms.MenuItem
    Private WithEvents menuItemExit As System.Windows.Forms.MenuItem
    Private WithEvents menuItemNewCar As System.Windows.Forms.MenuItem
    Private WithEvents menuItem1 As System.Windows.Forms.MenuItem
    Private WithEvents mainMenu As System.Windows.Forms.MainMenu
    Friend WithEvents carDataGrid As System.Windows.Forms.DataGrid
    

    ' Liste pour la srialisationde l'objet.
    Private arTheCars As ArrayList

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'Cet appel est requis par le concepteur Windows Form.
        InitializeComponent()

        CenterToScreen()
        ' Ajouter des voitures.
        arTheCars = New ArrayList()
        arTheCars.Add(New Car("Siddhartha", "BMW", "Argent"))
        arTheCars.Add(New Car("Chucky", "Caravan", "Vert petit pois"))
        arTheCars.Add(New Car("Fred", "Audi TT", "Rouge"))
        UpdateGrid()
    End Sub

    'La classe Form surcharge la mthode dispose pour nettoyer la liste de composants.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Requis par le Concepteur Windows Form
    Private components As System.ComponentModel.Container

    'NOTE: La procdure suivante est requise par le Concepteur Windows Form
    'Elle peut tre modifie en utilisant le Concepteur Windows Form.  
    'Ne pas la modifier en utilisant le Concepteur Windows Form.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.menuItemOpen = New System.Windows.Forms.MenuItem()
        Me.menuItemExit = New System.Windows.Forms.MenuItem()
        Me.carDataGrid = New System.Windows.Forms.DataGrid()
        Me.menuItemClear = New System.Windows.Forms.MenuItem()
        Me.mainMenu = New System.Windows.Forms.MainMenu()
        Me.menuItem1 = New System.Windows.Forms.MenuItem()
        Me.menuItemNewCar = New System.Windows.Forms.MenuItem()
        Me.menuItemSave = New System.Windows.Forms.MenuItem()
        CType(Me.carDataGrid, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.SuspendLayout()
        '
        'menuItemOpen
        '
        Me.menuItemOpen.Index = 2
        Me.menuItemOpen.Text = "Ouvrir un fichier voiture"
        '
        'menuItemExit
        '
        Me.menuItemExit.Index = 4
        Me.menuItemExit.Text = "Sortie"
        '
        'carDataGrid
        '
        Me.carDataGrid.AlternatingBackColor = System.Drawing.Color.Silver
        Me.carDataGrid.BackColor = System.Drawing.Color.White
        Me.carDataGrid.CaptionBackColor = System.Drawing.Color.Maroon
        Me.carDataGrid.CaptionFont = New System.Drawing.Font("Tahoma", 8!)
        Me.carDataGrid.CaptionForeColor = System.Drawing.Color.White
        Me.carDataGrid.CaptionText = "Les voitures"
        Me.carDataGrid.DataMember = ""
        Me.carDataGrid.Font = New System.Drawing.Font("Tahoma", 8!)
        Me.carDataGrid.ForeColor = System.Drawing.Color.Black
        Me.carDataGrid.GridLineColor = System.Drawing.Color.Silver
        Me.carDataGrid.HeaderBackColor = System.Drawing.Color.Silver
        Me.carDataGrid.HeaderFont = New System.Drawing.Font("Tahoma", 8!)
        Me.carDataGrid.HeaderForeColor = System.Drawing.Color.Black
        Me.carDataGrid.LinkColor = System.Drawing.Color.Maroon
        Me.carDataGrid.Location = New System.Drawing.Point(16, 32)
        Me.carDataGrid.Name = "carDataGrid"
        Me.carDataGrid.ParentRowsBackColor = System.Drawing.Color.Silver
        Me.carDataGrid.ParentRowsForeColor = System.Drawing.Color.Black
        Me.carDataGrid.SelectionBackColor = System.Drawing.Color.Maroon
        Me.carDataGrid.SelectionForeColor = System.Drawing.Color.White
        Me.carDataGrid.Size = New System.Drawing.Size(400, 144)
        Me.carDataGrid.TabIndex = 0
        '
        'menuItemClear
        '
        Me.menuItemClear.Index = 1
        Me.menuItemClear.Text = "Effacer une voiture"
        '
        'mainMenu
        '
        Me.mainMenu.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.menuItem1})
        '
        'menuItem1
        '
        Me.menuItem1.Index = 0
        Me.menuItem1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.menuItemNewCar, Me.menuItemClear, Me.menuItemOpen, Me.menuItemSave, Me.menuItemExit})
        Me.menuItem1.Text = "Fichier"
        '
        'menuItemNewCar
        '
        Me.menuItemNewCar.DefaultItem = True
        Me.menuItemNewCar.Index = 0
        Me.menuItemNewCar.Text = "Construire une nouvelle voiture"
        '
        'menuItemSave
        '
        Me.menuItemSave.Index = 3
        Me.menuItemSave.Text = "Sauver un fichier voiture"
        '
        'Form1
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(440, 201)
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.carDataGrid})
        Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog
        Me.Menu = Me.mainMenu
        Me.Name = "Form1"
        Me.Text = "Application de sauvegarde de voiture"
        CType(Me.carDataGrid, System.ComponentModel.ISupportInitialize).EndInit()
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Sub menuItemNewCar_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles menuItemNewCar.Click
        Dim d As AddCarDlg = New AddCarDlg()
        If (d.ShowDialog() = DialogResult.OK) Then
            '  Ajouter une nouvelle  voiture  l'objet arraylist.
            arTheCars.Add(d.theCar)
            UpdateGrid()
        End If
    End Sub

    Private Sub menuItemClear_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles menuItemClear.Click
        arTheCars.Clear()
        UpdateGrid()
    End Sub

    Private Sub menuItemOpen_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles menuItemOpen.Click
        ' Configurer l'aspect de la boite d'ouverture de fichier.
        Dim myOpenFileDialog As OpenFileDialog = New OpenFileDialog()
        myOpenFileDialog.InitialDirectory = "."
        myOpenFileDialog.Filter = "car files (*.car)|*.car|All files (*.*)|*.*"
        myOpenFileDialog.FilterIndex = 1
        myOpenFileDialog.RestoreDirectory = True

        ' Avons nous un fichier?
        If (myOpenFileDialog.ShowDialog() = DialogResult.OK) Then
            ' Effacer la liste.
            arTheCars.Clear()
            Dim myStream As Stream
            myStream = myOpenFileDialog.OpenFile()
            If (Not myStream Is Nothing) Then
                ' Rcuprer les voitures!
                Dim myBinaryFormat As BinaryFormatter = New BinaryFormatter()
                arTheCars = CType(myBinaryFormat.Deserialize(myStream), ArrayList)
                myStream.Close()
                UpdateGrid()
            End If
        End If
    End Sub

    Private Sub menuItemSave_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles menuItemSave.Click
        ' Configurer l'aspect de la boite de sauvegarde.
        Dim mySaveFileDialog As SaveFileDialog = New SaveFileDialog()
        mySaveFileDialog.InitialDirectory = "."
        mySaveFileDialog.Filter = "car files (*.car)|*.car|All files (*.*)|*.*"
        mySaveFileDialog.FilterIndex = 1
        mySaveFileDialog.RestoreDirectory = True
        mySaveFileDialog.FileName = "carDoc"

        ' Avons nous un fichier?
        If (mySaveFileDialog.ShowDialog() = DialogResult.OK) Then
            Dim myStream As Stream
            myStream = mySaveFileDialog.OpenFile()
            If (Not myStream Is Nothing) Then
                ' Sauver les voitures!
                Dim myBinaryFormat As BinaryFormatter = New BinaryFormatter()
                myBinaryFormat.Serialize(myStream, arTheCars)
                myStream.Close()
            End If
        End If
    End Sub

    Private Sub menuItemExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles menuItemExit.Click
        Application.Exit()
    End Sub

    Private Sub UpdateGrid()

        If (Not arTheCars Is Nothing) Then

            '  Construie un objet DataTable nomm Inventory.
            Dim inventory As DataTable = New DataTable("Inventory")

            ' Crer des objets DataColumn.
            Dim make As DataColumn = New DataColumn("Car Make")
            Dim petName As DataColumn = New DataColumn("Pet Name")
            Dim color As DataColumn = New DataColumn("Car Color")

            ' Ajouter des colonnes  la table de donne.
            inventory.Columns.Add(petName)
            inventory.Columns.Add(make)
            inventory.Columns.Add(color)

            ' Parcourir la liste de tableau pour construire des lignes.
            Dim c As Car
            For Each c In arTheCars
                Dim newRow As DataRow
                newRow = inventory.NewRow()
                newRow("Pet Name") = c.mPetName
                newRow("Car Make") = c.mMake
                newRow("Car Color") = c.mColor
                inventory.Rows.Add(newRow)
            Next

            ' Maintenant ajouter cette table de donnes  la grille.
            carDataGrid.DataSource = inventory
        End If
    End Sub
End Class
